//=============================================================================
// VisuStella MZ - State Tooltips
// VisuMZ_3_StateTooltips.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_3_StateTooltips = true;

var VisuMZ = VisuMZ || {};
VisuMZ.StateTooltips = VisuMZ.StateTooltips || {};
VisuMZ.StateTooltips.version = 1.03;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 3] [Version 1.03] [StateTooltips]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/State_Tooltips_VisuStella_MZ
 * @base VisuMZ_1_BattleCore
 * @base VisuMZ_1_MessageCore
 * @base VisuMZ_1_SkillsStatesCore
 * @orderAfter VisuMZ_1_BattleCore
 * @orderAfter VisuMZ_1_MessageCore
 * @orderAfter VisuMZ_1_SkillsStatesCore
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * This plugin adds a tooltip window in battle (and other scenes) whenever the
 * player's mouse cursor is hovered over specific areas of the screen. The
 * tooltip window will display a list of the states, buffs, and debuffs the
 * hovered battler has along with a description of the entities and their
 * remaining duration.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Tooltip window displays when hovering over battlers and specific windows
 *   to display their states, buffs, and debuffs.
 * * Adjust the text format in which information is displayed inside the
 *   tooltip window.
 * * Modify the descriptions for states, buffs, and debuffs to your liking.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * VisuMZ_1_BattleCore
 * * VisuMZ_1_MessageCore
 * * VisuMZ_1_SkillsStatesCore
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 *
 * ------ Tier 3 ------
 *
 * This plugin is a Tier 3 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 *
 * VisuMZ_2_PartySystem
 * 
 * VisuMZ_2_ClassChangeSystem
 *
 * These plugins have scenes that also support tooltips if this plugin is also
 * installed while those are active in your game's project.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 *
 * VisuMZ_2_DragonbonesUnion
 *
 * If you are using a Dragonbones Battler and want to apply a state tooltip to
 * it, the access area of the battler will be based on the hitbox size you
 * declare for the Dragonbones Battler with notetags. This is because all
 * Dragonbones battlers do not have innate automatically calculated hitbox
 * sizes as a result of their dynamically animated nature.
 * 
 * Please refer to the notetag section of the Dragonbones Union plugin for
 * Dragonbones Battler hitboxes to learn how to apply hitbox sizes.
 *
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 * 
 * === Description-Related Notetags ===
 * 
 * ---
 *
 * <Help Description>
 *  text
 *  text
 * </Help Description>
 *
 * - Used for: State Notetags
 * - Assigns a help description for the state.
 * - Replace 'text' with text you want displayed for the tooltip window.
 * - This best works with one line.
 * - If this notetag is not used, the help description will default to the
 *   setting found in the plugin's Plugin Parameters.
 * - Insert %1 into the help description to show any data that would otherwise
 *   be shown as the state display, such as Absorption Barrier count.
 *
 * ---
 * 
 * <Exclude From Tooltips>
 * 
 * - Used for: State Notetags
 * - Excludes the state from being displayed in the state tooltips.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Tooltip Settings
 * ============================================================================
 *
 * General settings for the State Tooltips Window.
 *
 * ---
 *
 * Appearance
 * 
 *   Scale:
 *   - What scale size do you want for the tooltip?
 *   - Use 1.0 for normal size.
 * 
 *   Skin Filename:
 *   - What window skin do you want to use for the tooltip?
 * 
 *   Skin Opacity:
 *   - What opacity setting is used for the tooltip?
 *   - Use a number between 0 and 255.
 *
 * ---
 *
 * Offset
 * 
 *   Offset X:
 *   - Offset the tooltip X position from the mouse?
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offset the tooltip Y position from the mouse?
 *   - Negative: up. Positive: down.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Vocabulary Settings
 * ============================================================================
 *
 * Vocabulary settings for the State Tooltips Window.
 *
 * ---
 *
 * General
 * 
 *   Default Description:
 *   - This is the default description that appears for a state without a
 *     declared description. %1 - State's Name
 *   - Can use text codes.
 *
 * ---
 *
 * Entries
 * 
 *   State Format:
 *   - Can use text codes.
 *   - %1 - Icon, %2 - Name, %3 - Description, %4 - Duration, %5 - State Color
 * 
 *   Buff Format:
 *   - Can use text codes.
 *   - %1 - Icon, %2 - Name, %3 - Percentage, %4 - Duration, %5 - Buff Color
 * 
 *   Debuff Format:
 *   - Can use text codes.
 *   - %1 - Icon, %2 - Name, %3 - Percentage, %4 - Duration, %5 - Debuff Color
 * 
 *   Replace Whites?:
 *   - If state, buff, debuff names are white, replace them?
 * 
 *     Replacement Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 *
 * ---
 *
 * Turns Remaining
 * 
 *   Action End Format:
 *   - Can use text codes.
 *   - %1 - Remaining, %2 - State/Buff/Debuff Color
 * 
 *   Turn End Format:
 *   - Can use text codes.
 *   - %1 - Remaining, %2 - State/Buff/Debuff Color
 * 
 *   Passive Text:
 *   - Can use text codes.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Window Settings
 * ============================================================================
 *
 * Choose which windows to enable tooltip support for.
 *
 * ---
 *
 * Settings
 * 
 *   Window_BattleStatus:
 *   Window_ClassStatus:
 *   Window_EquipStatus:
 *   Window_MenuActor:
 *   Window_MenuStatus:
 *   Window_PartyStatus:
 *   Window_SkillStatus:
 *   Window_Status:
 *   - Enable State Tooltips for this window?
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.03: October 7, 2021
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * 
 * Version 1.02: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetag added by Irina.
 * *** <Exclude From Tooltips>
 * **** Excludes the state from being displayed in the state tooltips.
 * 
 * Version 1.01: April 2, 2021
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_2_DragonbonesUnion plugin.
 * 
 * Version 1.00 Official Release Date: February 24, 2021
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param StateTooltips
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Tooltip:struct
 * @text Tooltip Settings
 * @type struct<Tooltip>
 * @desc General settings for the State Tooltips Window.
 * @default {"Appearance":"","Scale:num":"0.6","WindowSkin:str":"Window","WindowOpacity:num":"240","Offset":"","OffsetX:num":"+0","OffsetY:num":"+0"}
 *
 * @param Vocab:struct
 * @text Vocabulary Settings
 * @type struct<Vocab>
 * @desc Vocabulary settings for the State Tooltips Window.
 * @default {"General":"","HelpDescription:json":"\"-\"","Entries":"","StateFmt:str":"\\C[%5]%1%2:\\C[0] %3 %4","BuffFmt:str":"\\C[%5]%1%2:\\C[0] Increases unit's %2 to \\C[%5]%3%\\C[0] %4","DebuffFmt:str":"\\C[%5]%1%2:\\C[0] Decreases unit's %2 to \\C[%5]%3%\\C[0] %4","ReplaceWhite:eval":"true","WhiteReplaceColor:str":"5","Turns":"","ActionsFmt:str":"\\C[6](Actions \\C[%2]%1\\C[6])\\C[0]","TurnsFmt:str":"\\C[5](Turns \\C[%2]%1\\C[5])\\C[0]","PassiveText:str":"\\C[4](Passive)\\C[0]"}
 *
 * @param Window:struct
 * @text Window Settings
 * @type struct<Window>
 * @desc Choose which windows to enable tooltip support for.
 * @default {"Window_BattleStatus:eval":"true","Window_ClassStatus:eval":"true","Window_EquipStatus:eval":"true","Window_MenuActor:eval":"true","Window_MenuStatus:eval":"true","Window_PartyStatus:eval":"true","Window_SkillStatus:eval":"true","Window_Status:eval":"true"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Tooltip Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Tooltip:
 *
 * @param Appearance
 *
 * @param Scale:num
 * @text Scale
 * @parent Appearance
 * @desc What scale size do you want for the tooltip?
 * Use 1.0 for normal size.
 * @default 0.6
 *
 * @param WindowSkin:str
 * @text Skin Filename
 * @parent Appearance
 * @type file
 * @dir img/system/
 * @desc What window skin do you want to use for the tooltip?
 * @default Window
 *
 * @param WindowOpacity:num
 * @text Skin Opacity
 * @parent Appearance
 * @type number
 * @min 0
 * @max 255
 * @desc What opacity setting is used for the tooltip?
 * Use a number between 0 and 255.
 * @default 240
 *
 * @param Offset
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Offset
 * @desc Offset the tooltip X position from the mouse?
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Offset
 * @desc Offset the tooltip Y position from the mouse?
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Vocab Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Vocab:
 *
 * @param General
 *
 * @param HelpDescription:json
 * @text Default Description
 * @parent General
 * @type note
 * @desc This is the default description that appears for a state
 * without a declared description. %1 - State's Name
 * @default "-"
 * 
 * @param Entries
 *
 * @param StateFmt:str
 * @text State Format
 * @parent Entries
 * @desc Can use text codes. %1 - Icon, %2 - Name,
 * %3 - Description, %4 - Duration, %5 - State Color
 * @default \C[%5]%1%2:\C[0] %3 %4
 *
 * @param BuffFmt:str
 * @text Buff Format
 * @parent Entries
 * @desc Can use text codes. %1 - Icon, %2 - Name,
 * %3 - Percentage, %4 - Duration, %5 - Buff Color
 * @default \C[%5]%1%2:\C[0] Increases unit's %2 to \C[%5]%3%\C[0] %4
 *
 * @param DebuffFmt:str
 * @text Debuff Format
 * @parent Entries
 * @desc Can use text codes. %1 - Icon, %2 - Name,
 * %3 - Percentage, %4 - Duration, %5 - Debuff Color
 * @default \C[%5]%1%2:\C[0] Decreases unit's %2 to \C[%5]%3%\C[0] %4
 *
 * @param ReplaceWhite:eval
 * @text Replace Whites?
 * @parent Entries
 * @type boolean
 * @on Replace
 * @off Don't Replace
 * @desc If state, buff, debuff names are white, replace them?
 * @default true
 *
 * @param WhiteReplaceColor:str
 * @text Replacement Color
 * @parent ReplaceWhite:eval
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default 5
 * 
 * @param Turns
 * @text Turns Remaining
 *
 * @param ActionsFmt:str
 * @text Action End Format
 * @parent Turns
 * @desc Can use text codes.
 * %1 - Remaining, %2 - State/Buff/Debuff Color
 * @default \C[6](Actions \C[%2]%1\C[6])\C[0]
 *
 * @param TurnsFmt:str
 * @text Turn End Format
 * @parent Turns
 * @desc Can use text codes.
 * %1 - Remaining, %2 - State/Buff/Debuff Color
 * @default \C[5](Turns \C[%2]%1\C[5])\C[0]
 *
 * @param PassiveText:str
 * @text Passive Text
 * @parent Turns
 * @desc Can use text codes.
 * @default \C[4](Passive)\C[0]
 *
 */
/* ----------------------------------------------------------------------------
 * Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Window:
 *
 * @param Window_BattleStatus:eval
 * @text Window_BattleStatus
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 * @param Window_ClassStatus:eval
 * @text Window_ClassStatus
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 * @param Window_EquipStatus:eval
 * @text Window_EquipStatus
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 * @param Window_MenuActor:eval
 * @text Window_MenuActor
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 * @param Window_MenuStatus:eval
 * @text Window_MenuStatus
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 * @param Window_PartyStatus:eval
 * @text Window_PartyStatus
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 * @param Window_SkillStatus:eval
 * @text Window_SkillStatus
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 * @param Window_Status:eval
 * @text Window_Status
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Enable State Tooltips for this window?
 * @default true
 *
 */
//=============================================================================

const _0x1c877c=_0x32fe;(function(_0x20f4e7,_0xd1f9a0){const _0x16327e=_0x32fe,_0x4237da=_0x20f4e7();while(!![]){try{const _0xc0349c=-parseInt(_0x16327e(0x18e))/0x1+parseInt(_0x16327e(0x12a))/0x2*(-parseInt(_0x16327e(0x153))/0x3)+parseInt(_0x16327e(0x13b))/0x4+parseInt(_0x16327e(0x19e))/0x5+parseInt(_0x16327e(0x17d))/0x6*(parseInt(_0x16327e(0x122))/0x7)+parseInt(_0x16327e(0x152))/0x8+-parseInt(_0x16327e(0x127))/0x9*(parseInt(_0x16327e(0x1a4))/0xa);if(_0xc0349c===_0xd1f9a0)break;else _0x4237da['push'](_0x4237da['shift']());}catch(_0x544c38){_0x4237da['push'](_0x4237da['shift']());}}}(_0x48b9,0x471a0));var label=_0x1c877c(0x19a),tier=tier||0x0,dependencies=['VisuMZ_1_BattleCore'],pluginData=$plugins[_0x1c877c(0x1ab)](function(_0x38d76e){const _0x287831=_0x1c877c;return _0x38d76e['status']&&_0x38d76e[_0x287831(0x14c)][_0x287831(0x16a)]('['+label+']');})[0x0];function _0x48b9(){const _0x2a0995=['setupBuffTurnText','NUM','Sprite_Clickable_onMouseEnter','touchY','NONWHITE_COLOR','onMouseEnterStateTooltips','drawTextEx','StateTooltips','clear','isBuffAffected','map','2233255AEmxTB','ParseStateNotetags','buffIconIndex','stateColor','toUpperCase','\x5cI[%1]','1991640nGyKYV','buffColor','touchX','STATE_FMT','onDatabaseLoaded','_skillWindow','length','filter','refreshStateTooltipBattler','isDead','HEXCOLOR','PassiveText','replace','ARRAYEVAL','Settings','jLXjL','OffsetX','TurnsFmt','process_VisuMZ_StateTooltips','ConvertParams','VisuMZ_2_ClassChangeSystem','setupBuffText','Parse_Notetags_Description','show','WindowOpacity','process_VisuMZ_StateTooltips_Notetags','processTouchStateTooltips','FUNC','GbRrJ','ParseAllNotetags','targetOpacity','hide','constructor','ReplaceWhite','update','BuffFmt','DebuffFmt','%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.','GFtLb','currentTooltipBattler','isOpen','loadSystem','match','max','STRUCT','CVNdl','TURNS_FMT','ARRAYJSON','getColor','updateBackOpacity','ARRAYFUNC','WINDOW_SCALE','Game_Battler_refresh','aXxQY','_text','push','scale','call','PASSIVE_TEXT','applyInverse','Vocab','\x5cHEXCOLOR<#%1>','_actor','RegExp','REPLACE_WHITE','round','processEscapeCharacter','clampPosition','WINDOW_SKIN_OPACITY','contents','parameters','onMouseExitStateTooltips','ARRAYNUM','Sprite_Clickable_onMouseExit','STR','%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.','states','convertMessageKeywords','open','359009DAAyvf','setBattler','PEIMv','Window_Selectable_processTouch','MOUSE_OFFSET_Y','9IyjyQj','Scene_Boot_onDatabaseLoaded','contentsOpacity','64OcTMJm','opacity','width','MNKMU','isBuffOrDebuffAffected','EVAL','getStateTooltipBattler','OffsetY','debuffColor','version','Exclude','_cache_StateTooltips','obtainEscapeString','parse','MOUSE_OFFSET_X','Tooltip','processTouch','1553912Contkb','PtGoG','contains','requestRefresh','closeTouchStateTooltips','updatePosition','isSceneBattle','zxFVQ','ACTIONS_FMT','return\x200','actor','Scene_Base_createWindowLayer','initialize','onMouseExit','note','clamp','isStateTooltipEnabled','description','ismdd','Sprite_Battler_onMouseEnter','battler','ActionsFmt','height','167848DeUqgz','31113xnNjOO','_requestRefresh','Scale','windowskin','isMouseHovered','_actorCommandWindow','refresh','autoRemovalTiming','paramBuffRate','setStateTooltipBattler','setupStateTurnText','openTouchStateTooltips','isColorLocked','setupStateText','HelpDescription','updateDeath','nRfqq','textSizeEx','eFaiL','isSupportMessageKeywords','WINDOW_SKIN_FILENAME','cTqDV','iconIndex','includes','passiveStates','stateTurns','exit','wHbsq','visible','bzOJE','_stateTooltipWindow','WindowSkin','createStateTooltipWindow','updateOpacity','floor','isStateTooltipTouched','createWindowLayer','loadWindowskin','padding','hitIndex','RqhUf','replaceHexColors','6xKUQjo','XepfO','isAppeared','name','isStateTooltipHovered','backOpacity','dimensionRect','trim','createContents','DEBUFF_FMT','prototype','ffffff','format','onMouseEnter','worldTransform','BUFF_FMT','_scene','85129yuUOME','hitTest','MKxMV','buffTurns','_battler'];_0x48b9=function(){return _0x2a0995;};return _0x48b9();}VisuMZ[label][_0x1c877c(0x1b2)]=VisuMZ[label]['Settings']||{},VisuMZ[_0x1c877c(0x1b7)]=function(_0x5645d9,_0x42d2c5){const _0x4bb9fe=_0x1c877c;for(const _0x36f26b in _0x42d2c5){if(_0x36f26b[_0x4bb9fe(0xfd)](/(.*):(.*)/i)){if(_0x4bb9fe(0x17e)!==_0x4bb9fe(0x14d)){const _0x5a31d2=String(RegExp['$1']),_0x46bf00=String(RegExp['$2'])[_0x4bb9fe(0x1a2)]()['trim']();let _0x23f042,_0x3fd5b3,_0x16a7b4;switch(_0x46bf00){case _0x4bb9fe(0x194):_0x23f042=_0x42d2c5[_0x36f26b]!==''?Number(_0x42d2c5[_0x36f26b]):0x0;break;case _0x4bb9fe(0x11b):_0x3fd5b3=_0x42d2c5[_0x36f26b]!==''?JSON['parse'](_0x42d2c5[_0x36f26b]):[],_0x23f042=_0x3fd5b3[_0x4bb9fe(0x19d)](_0x487fe2=>Number(_0x487fe2));break;case _0x4bb9fe(0x12f):_0x23f042=_0x42d2c5[_0x36f26b]!==''?eval(_0x42d2c5[_0x36f26b]):null;break;case _0x4bb9fe(0x1b1):_0x3fd5b3=_0x42d2c5[_0x36f26b]!==''?JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b]):[],_0x23f042=_0x3fd5b3['map'](_0x4a274d=>eval(_0x4a274d));break;case'JSON':_0x23f042=_0x42d2c5[_0x36f26b]!==''?JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b]):'';break;case _0x4bb9fe(0x102):_0x3fd5b3=_0x42d2c5[_0x36f26b]!==''?JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b]):[],_0x23f042=_0x3fd5b3[_0x4bb9fe(0x19d)](_0x27b2c8=>JSON[_0x4bb9fe(0x137)](_0x27b2c8));break;case _0x4bb9fe(0xee):_0x23f042=_0x42d2c5[_0x36f26b]!==''?new Function(JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b])):new Function(_0x4bb9fe(0x144));break;case _0x4bb9fe(0x105):_0x3fd5b3=_0x42d2c5[_0x36f26b]!==''?JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b]):[],_0x23f042=_0x3fd5b3[_0x4bb9fe(0x19d)](_0x2583ef=>new Function(JSON['parse'](_0x2583ef)));break;case _0x4bb9fe(0x11d):_0x23f042=_0x42d2c5[_0x36f26b]!==''?String(_0x42d2c5[_0x36f26b]):'';break;case'ARRAYSTR':_0x3fd5b3=_0x42d2c5[_0x36f26b]!==''?JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b]):[],_0x23f042=_0x3fd5b3[_0x4bb9fe(0x19d)](_0x511637=>String(_0x511637));break;case _0x4bb9fe(0xff):_0x16a7b4=_0x42d2c5[_0x36f26b]!==''?JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b]):{},_0x23f042=VisuMZ[_0x4bb9fe(0x1b7)]({},_0x16a7b4);break;case'ARRAYSTRUCT':_0x3fd5b3=_0x42d2c5[_0x36f26b]!==''?JSON[_0x4bb9fe(0x137)](_0x42d2c5[_0x36f26b]):[],_0x23f042=_0x3fd5b3['map'](_0x5ab3aa=>VisuMZ[_0x4bb9fe(0x1b7)]({},JSON[_0x4bb9fe(0x137)](_0x5ab3aa)));break;default:continue;}_0x5645d9[_0x5a31d2]=_0x23f042;}else this['setStateTooltipBattler']();}}return _0x5645d9;},(_0x214bf2=>{const _0x10db4d=_0x1c877c,_0x114a15=_0x214bf2[_0x10db4d(0x180)];for(const _0x40023d of dependencies){if(!Imported[_0x40023d]){alert(_0x10db4d(0x11e)[_0x10db4d(0x189)](_0x114a15,_0x40023d)),SceneManager[_0x10db4d(0x16d)]();break;}}const _0x2baf5a=_0x214bf2['description'];if(_0x2baf5a[_0x10db4d(0xfd)](/\[Version[ ](.*?)\]/i)){if('HBtxh'===_0x10db4d(0x165))return this[_0x10db4d(0x111)];else{const _0x3949f5=Number(RegExp['$1']);if(_0x3949f5!==VisuMZ[label][_0x10db4d(0x133)]){if('GbRrJ'===_0x10db4d(0xef))alert('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'['format'](_0x114a15,_0x3949f5)),SceneManager['exit']();else{if(!this['visible'])return;this['x']=_0x284340['x']+_0x135bb0['MOUSE_OFFSET_X'],this['y']=_0x384308['y']+_0x4700f1['MOUSE_OFFSET_Y'],this[_0x10db4d(0x116)]();}}}}if(_0x2baf5a['match'](/\[Tier[ ](\d+)\]/i)){const _0x363865=Number(RegExp['$1']);_0x363865<tier?(alert(_0x10db4d(0xf8)[_0x10db4d(0x189)](_0x114a15,_0x363865,tier)),SceneManager['exit']()):_0x10db4d(0xf9)===_0x10db4d(0xf9)?tier=Math[_0x10db4d(0xfe)](_0x363865,tier):this[_0x10db4d(0x159)]();}VisuMZ[_0x10db4d(0x1b7)](VisuMZ[label][_0x10db4d(0x1b2)],_0x214bf2[_0x10db4d(0x119)]);})(pluginData),VisuMZ['StateTooltips']['RegExp']={'HelpDescription':/<(?:HELP|HELP DESCRIPTION|DESCRIPTION)>\s*([\s\S]*)\s*<\/(?:HELP|HELP DESCRIPTION|DESCRIPTION)>/i,'Exclude':/<EXCLUDE FROM (?:TOOLTIP|TOOLTIPS)>/i},VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x128)]=Scene_Boot[_0x1c877c(0x187)][_0x1c877c(0x1a8)],Scene_Boot[_0x1c877c(0x187)][_0x1c877c(0x1a8)]=function(){const _0x55cde8=_0x1c877c;VisuMZ[_0x55cde8(0x19a)]['Scene_Boot_onDatabaseLoaded'][_0x55cde8(0x10c)](this),this[_0x55cde8(0x1b6)]();},Scene_Boot[_0x1c877c(0x187)][_0x1c877c(0x1b6)]=function(){const _0x519e28=_0x1c877c;this[_0x519e28(0xec)]();},Scene_Boot['prototype'][_0x1c877c(0xec)]=function(){const _0xa2878b=_0x1c877c;if(VisuMZ[_0xa2878b(0xf0)])return;for(const _0x599389 of $dataStates){if(!_0x599389)continue;VisuMZ[_0xa2878b(0x19a)][_0xa2878b(0x1ba)](_0x599389);}},VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x19f)]=VisuMZ[_0x1c877c(0x19f)],VisuMZ['ParseStateNotetags']=function(_0x4b77a2){const _0x4affb9=_0x1c877c;VisuMZ['StateTooltips'][_0x4affb9(0x19f)]['call'](this,_0x4b77a2),VisuMZ[_0x4affb9(0x19a)][_0x4affb9(0x1ba)](_0x4b77a2);},VisuMZ['StateTooltips'][_0x1c877c(0x1ba)]=function(_0x56cdfc){const _0x4abf32=_0x1c877c;_0x56cdfc[_0x4abf32(0x14c)]=VisuMZ[_0x4abf32(0x19a)][_0x4abf32(0x1b2)][_0x4abf32(0x10f)][_0x4abf32(0x161)];const _0x5aa6b3=VisuMZ[_0x4abf32(0x19a)][_0x4abf32(0x112)],_0x118b66=_0x56cdfc[_0x4abf32(0x149)];_0x118b66[_0x4abf32(0xfd)](_0x5aa6b3[_0x4abf32(0x161)])&&(_0x56cdfc['description']=String(RegExp['$1'])['trim']());},ColorManager[_0x1c877c(0x103)]=function(_0x55d70e){const _0x2d08bf=_0x1c877c;return _0x55d70e=String(_0x55d70e),_0x55d70e['match'](/#(.*)/i)?'#%1'[_0x2d08bf(0x189)](String(RegExp['$1'])):this['textColor'](Number(_0x55d70e));},SceneManager[_0x1c877c(0x141)]=function(){const _0x3a3f5f=_0x1c877c;return this[_0x3a3f5f(0x18d)]&&this[_0x3a3f5f(0x18d)]['constructor']===Scene_Battle;},SceneManager[_0x1c877c(0xfa)]=function(){const _0x48f966=_0x1c877c,_0x41b02f=SceneManager[_0x48f966(0x18d)]['_stateTooltipWindow'];if(!_0x41b02f)return null;return _0x41b02f['_battler'];},SceneManager[_0x1c877c(0x15c)]=function(_0x3a3bd7){const _0x510319=_0x1c877c;if(_0x3a3bd7&&!_0x3a3bd7[_0x510319(0x17f)]())return;if(_0x3a3bd7&&_0x3a3bd7[_0x510319(0x1ad)]())return;const _0x494c0d=SceneManager[_0x510319(0x18d)][_0x510319(0x171)];if(!_0x494c0d)return;_0x494c0d[_0x510319(0x123)](_0x3a3bd7);},SceneManager[_0x1c877c(0x1ac)]=function(_0x64bd39){const _0x378ec8=_0x1c877c;if(_0x64bd39&&!_0x64bd39[_0x378ec8(0x17f)]())return;const _0x457f16=SceneManager[_0x378ec8(0x18d)][_0x378ec8(0x171)];if(!_0x457f16)return;if(_0x457f16[_0x378ec8(0x192)]!==_0x64bd39)return;_0x457f16[_0x378ec8(0x13e)]();},VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x107)]=Game_Battler['prototype']['refresh'],Game_Battler['prototype'][_0x1c877c(0x159)]=function(){const _0x1439b4=_0x1c877c;VisuMZ[_0x1439b4(0x19a)]['Game_Battler_refresh'][_0x1439b4(0x10c)](this),SceneManager[_0x1439b4(0x1ac)](this);},VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x146)]=Scene_Base[_0x1c877c(0x187)][_0x1c877c(0x177)],Scene_Base[_0x1c877c(0x187)][_0x1c877c(0x177)]=function(){const _0x43560e=_0x1c877c;VisuMZ[_0x43560e(0x19a)]['Scene_Base_createWindowLayer']['call'](this),this[_0x43560e(0x173)]();},Scene_Base[_0x1c877c(0x187)]['createStateTooltipWindow']=function(){this['_stateTooltipWindow']=new Window_StateTooltip(),this['addChild'](this['_stateTooltipWindow']);},VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x195)]=Sprite_Clickable[_0x1c877c(0x187)][_0x1c877c(0x18a)],Sprite_Clickable['prototype'][_0x1c877c(0x18a)]=function(){const _0x50f999=_0x1c877c;VisuMZ[_0x50f999(0x19a)][_0x50f999(0x195)][_0x50f999(0x10c)](this),this[_0x50f999(0x198)]();},VisuMZ['StateTooltips'][_0x1c877c(0x11c)]=Sprite_Clickable[_0x1c877c(0x187)]['onMouseExit'],Sprite_Clickable['prototype'][_0x1c877c(0x148)]=function(){const _0x1d1136=_0x1c877c;VisuMZ[_0x1d1136(0x19a)]['Sprite_Clickable_onMouseExit'][_0x1d1136(0x10c)](this),this[_0x1d1136(0x11a)]();},Sprite_Clickable['prototype'][_0x1c877c(0x198)]=function(){this['setStateTooltipBattler']();},Sprite_Clickable[_0x1c877c(0x187)]['onMouseExitStateTooltips']=function(){const _0x145c15=_0x1c877c,_0x538693=this[_0x145c15(0x130)]();_0x538693&&SceneManager['currentTooltipBattler']()===_0x538693&&SceneManager[_0x145c15(0x15c)](null);},Sprite_Clickable[_0x1c877c(0x187)][_0x1c877c(0x15c)]=function(){const _0x4eccc1=_0x1c877c,_0x2de9b1=this[_0x4eccc1(0x130)]();_0x2de9b1&&SceneManager[_0x4eccc1(0x15c)](_0x2de9b1);},Sprite_Clickable[_0x1c877c(0x187)]['getStateTooltipBattler']=function(){return null;},VisuMZ[_0x1c877c(0x19a)]['Sprite_Battler_onMouseEnter']=Sprite_Battler[_0x1c877c(0x187)][_0x1c877c(0x18a)],Sprite_Battler['prototype'][_0x1c877c(0x18a)]=function(){const _0x230f1d=_0x1c877c;VisuMZ[_0x230f1d(0x19a)][_0x230f1d(0x14e)][_0x230f1d(0x10c)](this),this[_0x230f1d(0x15c)]();},Sprite_Battler[_0x1c877c(0x187)][_0x1c877c(0x130)]=function(){const _0x134327=_0x1c877c;return this[_0x134327(0x192)];},Window_Base[_0x1c877c(0x187)][_0x1c877c(0x157)]=function(){const _0x1178fe=_0x1c877c,_0x33dcfc=new Point(TouchInput['x'],TouchInput['y']),_0x3459d9=this[_0x1178fe(0x18b)][_0x1178fe(0x10e)](_0x33dcfc);return this[_0x1178fe(0x183)]()[_0x1178fe(0x13d)](_0x3459d9['x'],_0x3459d9['y']);},Window_Base['prototype'][_0x1c877c(0x183)]=function(){const _0x36ca68=_0x1c877c;return new Rectangle(0x0,0x0,this[_0x36ca68(0x12c)],this[_0x36ca68(0x151)]);},VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x125)]=Window_Selectable[_0x1c877c(0x187)][_0x1c877c(0x13a)],Window_Selectable['prototype'][_0x1c877c(0x13a)]=function(){const _0xa25b96=_0x1c877c;VisuMZ[_0xa25b96(0x19a)][_0xa25b96(0x125)][_0xa25b96(0x10c)](this);if(this[_0xa25b96(0xf3)]['name'][_0xa25b96(0xfd)](/Debug/i))return;this[_0xa25b96(0xed)]();},Window_Selectable[_0x1c877c(0x187)]['processTouchStateTooltips']=function(){const _0x44d580=_0x1c877c;if(!this[_0x44d580(0x14b)]())return;this[_0x44d580(0x135)]=this[_0x44d580(0x135)]||{};if(!this[_0x44d580(0xfb)]()){if(this[_0x44d580(0x135)]['open']){if(_0x44d580(0x12d)!==_0x44d580(0x12d)){_0x5b6eb7[_0x44d580(0x14c)]=_0x5e0ba2['StateTooltips'][_0x44d580(0x1b2)]['Vocab'][_0x44d580(0x161)];const _0x4e4eaa=_0x29e1eb[_0x44d580(0x19a)]['RegExp'],_0x56eec5=_0xe00247[_0x44d580(0x149)];_0x56eec5[_0x44d580(0xfd)](_0x4e4eaa[_0x44d580(0x161)])&&(_0x4bfe01[_0x44d580(0x14c)]=_0x47b4cf(_0x42285b['$1'])[_0x44d580(0x184)]());}else this[_0x44d580(0x13f)]();}return;}else this['_cache_StateTooltips'][_0x44d580(0x121)]=!![];if(!this['visible']){if(this[_0x44d580(0x135)][_0x44d580(0x16f)]){if(_0x44d580(0x17b)===_0x44d580(0x163))return _0xac10e3=_0x3cb4e9(_0x329deb),_0x5c0797[_0x44d580(0xfd)](/#(.*)/i)?'#%1'[_0x44d580(0x189)](_0x27b4e7(_0x4aac2b['$1'])):this['textColor'](_0x3c42f8(_0x4ecfd4));else this[_0x44d580(0x13f)]();}return;}else this['_cache_StateTooltips'][_0x44d580(0x16f)]=!![];(this[_0x44d580(0x135)]['x']!==this['x']||this[_0x44d580(0x135)]['y']!==this['y']||this[_0x44d580(0x135)][_0x44d580(0x1a6)]!==TouchInput['x']||this['_cache_StateTooltips']['touchX']!==TouchInput['y'])&&(_0x44d580(0x190)!=='aeiOI'?(this[_0x44d580(0x135)]['x']=this['x'],this['_cache_StateTooltips']['y']=this['y'],this[_0x44d580(0x135)][_0x44d580(0x1a6)]=TouchInput['x'],this[_0x44d580(0x135)][_0x44d580(0x196)]=TouchInput['y'],this[_0x44d580(0x176)]()?(this['_cache_StateTooltips'][_0x44d580(0x18f)]=!![],this[_0x44d580(0x15e)]()):this[_0x44d580(0x135)]['hitTest']&&this[_0x44d580(0x13f)]()):this[_0x44d580(0x135)][_0x44d580(0x18f)]&&this[_0x44d580(0x13f)]());},Window_Selectable[_0x1c877c(0x187)][_0x1c877c(0x14b)]=function(){const _0x4bd16d=_0x1c877c;return VisuMZ[_0x4bd16d(0x19a)]['Settings']['Window'][this[_0x4bd16d(0xf3)]['name']];},Window_Selectable[_0x1c877c(0x187)][_0x1c877c(0x176)]=function(){const _0xd807b0=_0x1c877c;return this[_0xd807b0(0x17a)]()>=0x0;},Window_Selectable[_0x1c877c(0x187)][_0x1c877c(0x181)]=function(){const _0x2be1af=_0x1c877c,_0x2c2a81=new Point(TouchInput['x'],TouchInput['y']),_0x2d3492=this[_0x2be1af(0x18b)][_0x2be1af(0x10e)](_0x2c2a81),_0x387dde=new Rectangle(0x0,0x0,this[_0x2be1af(0x12c)],this[_0x2be1af(0x151)]);return _0x387dde[_0x2be1af(0x13d)](_0x2d3492['x'],_0x2d3492['y']);},Window_Selectable[_0x1c877c(0x187)]['openTouchStateTooltips']=function(){const _0x5856cb=_0x1c877c,_0x1041dc=this[_0x5856cb(0x130)]();_0x1041dc?(this[_0x5856cb(0x135)][_0x5856cb(0x14f)]=_0x1041dc,SceneManager[_0x5856cb(0x15c)](_0x1041dc)):this[_0x5856cb(0x13f)]();},Window_Selectable[_0x1c877c(0x187)][_0x1c877c(0x130)]=function(){return null;},Window_Selectable[_0x1c877c(0x187)][_0x1c877c(0x13f)]=function(){const _0x19cb6b=_0x1c877c;this['_cache_StateTooltips'][_0x19cb6b(0x121)]=![],this[_0x19cb6b(0x135)][_0x19cb6b(0x16f)]=![],this['_cache_StateTooltips']['hitTest']=![],this[_0x19cb6b(0x135)][_0x19cb6b(0x14f)]&&(_0x19cb6b(0x124)!==_0x19cb6b(0x124)?(_0x4f116a['prototype'][_0x19cb6b(0xf5)][_0x19cb6b(0x10c)](this),this[_0x19cb6b(0x154)]&&(this[_0x19cb6b(0x154)]=![],this[_0x19cb6b(0x159)]()),this['updatePosition'](),this[_0x19cb6b(0x162)](),this[_0x19cb6b(0x174)]()):(SceneManager['setStateTooltipBattler'](null),this['_cache_StateTooltips'][_0x19cb6b(0x14f)]=null));},Window_MenuStatus[_0x1c877c(0x187)][_0x1c877c(0x130)]=function(){const _0x2cae34=_0x1c877c,_0x50e7cb=this[_0x2cae34(0x17a)](),_0x4052c6=this[_0x2cae34(0x145)](_0x50e7cb);return _0x4052c6;},Window_SkillStatus[_0x1c877c(0x187)][_0x1c877c(0x176)]=function(){const _0x36dff1=_0x1c877c;return this[_0x36dff1(0x181)]();},Window_SkillStatus[_0x1c877c(0x187)][_0x1c877c(0x130)]=function(){const _0x17df5e=_0x1c877c;return this[_0x17df5e(0x111)];},Window_EquipStatus[_0x1c877c(0x187)]['isStateTooltipTouched']=function(){const _0x219849=_0x1c877c;return this[_0x219849(0x181)]();},Window_EquipStatus[_0x1c877c(0x187)]['getStateTooltipBattler']=function(){const _0x4bf8ad=_0x1c877c;return this[_0x4bf8ad(0x111)];},Window_Status[_0x1c877c(0x187)]['isStateTooltipTouched']=function(){return this['isStateTooltipHovered']();},Window_Status[_0x1c877c(0x187)]['getStateTooltipBattler']=function(){const _0x134dd1=_0x1c877c;return this[_0x134dd1(0x111)];},Window_BattleStatus[_0x1c877c(0x187)]['getStateTooltipBattler']=function(){const _0x3f284d=_0x1c877c,_0x5b1970=this[_0x3f284d(0x17a)](),_0x239e0b=this[_0x3f284d(0x145)](_0x5b1970);return _0x239e0b;};Imported[_0x1c877c(0x1b8)]&&(Window_ClassStatus[_0x1c877c(0x187)][_0x1c877c(0x176)]=function(){const _0xfb6d4f=_0x1c877c;return this[_0xfb6d4f(0x181)]();},Window_ClassStatus[_0x1c877c(0x187)][_0x1c877c(0x130)]=function(){const _0x5cd7a3=_0x1c877c;return this[_0x5cd7a3(0x111)];});;Imported['VisuMZ_2_PartySystem']&&(Window_PartyStatus[_0x1c877c(0x187)][_0x1c877c(0x176)]=function(){return this['isStateTooltipHovered']();},Window_PartyStatus[_0x1c877c(0x187)][_0x1c877c(0x130)]=function(){const _0x2c674e=_0x1c877c;return this[_0x2c674e(0x111)];});function _0x32fe(_0x2b77f9,_0x51e94d){const _0x48b961=_0x48b9();return _0x32fe=function(_0x32fe9c,_0x306431){_0x32fe9c=_0x32fe9c-0xea;let _0x302e0c=_0x48b961[_0x32fe9c];return _0x302e0c;},_0x32fe(_0x2b77f9,_0x51e94d);};function Window_StateTooltip(){const _0x2e32ff=_0x1c877c;this[_0x2e32ff(0x147)](...arguments);}Window_StateTooltip[_0x1c877c(0x187)]=Object['create'](Window_Base['prototype']),Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0xf3)]=Window_StateTooltip,Window_StateTooltip[_0x1c877c(0x106)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x139)][_0x1c877c(0x155)],Window_StateTooltip[_0x1c877c(0x167)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x139)][_0x1c877c(0x172)],Window_StateTooltip[_0x1c877c(0x117)]=VisuMZ['StateTooltips'][_0x1c877c(0x1b2)][_0x1c877c(0x139)][_0x1c877c(0xeb)],Window_StateTooltip['STATE_FMT']=VisuMZ[_0x1c877c(0x19a)]['Settings'][_0x1c877c(0x10f)]['StateFmt'],Window_StateTooltip['BUFF_FMT']=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x10f)][_0x1c877c(0xf6)],Window_StateTooltip[_0x1c877c(0x186)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x10f)][_0x1c877c(0xf7)],Window_StateTooltip[_0x1c877c(0x143)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x10f)][_0x1c877c(0x150)],Window_StateTooltip['TURNS_FMT']=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x10f)][_0x1c877c(0x1b5)],Window_StateTooltip[_0x1c877c(0x10d)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x10f)][_0x1c877c(0x1af)],Window_StateTooltip[_0x1c877c(0x113)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x10f)][_0x1c877c(0xf4)],Window_StateTooltip[_0x1c877c(0x197)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x10f)]['WhiteReplaceColor'],Window_StateTooltip[_0x1c877c(0x138)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x139)][_0x1c877c(0x1b4)],Window_StateTooltip[_0x1c877c(0x126)]=VisuMZ[_0x1c877c(0x19a)][_0x1c877c(0x1b2)][_0x1c877c(0x139)][_0x1c877c(0x131)],Window_StateTooltip['prototype']['initialize']=function(){const _0x45e9f8=_0x1c877c,_0x44a8d7=new Rectangle(0x0,0x0,Graphics[_0x45e9f8(0x12c)],Graphics['height']);Window_Base[_0x45e9f8(0x187)][_0x45e9f8(0x147)][_0x45e9f8(0x10c)](this,_0x44a8d7),this[_0x45e9f8(0x10b)]['x']=this[_0x45e9f8(0x10b)]['y']=Window_StateTooltip[_0x45e9f8(0x106)],this['hide'](),this[_0x45e9f8(0x192)]=null;},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x178)]=function(){const _0x3f0e21=_0x1c877c;this[_0x3f0e21(0x156)]=ImageManager[_0x3f0e21(0xfc)](Window_StateTooltip['WINDOW_SKIN_FILENAME']);},Window_StateTooltip['prototype'][_0x1c877c(0x104)]=function(){const _0x30c70b=_0x1c877c;this[_0x30c70b(0x182)]=Window_StateTooltip[_0x30c70b(0x117)];},Window_StateTooltip[_0x1c877c(0x187)]['setBattler']=function(_0x31c473){const _0x23b53e=_0x1c877c;if(this['_battler']===_0x31c473)return;this[_0x23b53e(0x192)]=_0x31c473,this[_0x23b53e(0x192)]?this['refresh']():_0x23b53e(0x108)!==_0x23b53e(0x168)?this['hide']():(this[_0x23b53e(0x135)][_0x23b53e(0x121)]=![],this[_0x23b53e(0x135)][_0x23b53e(0x16f)]=![],this[_0x23b53e(0x135)][_0x23b53e(0x18f)]=![],this[_0x23b53e(0x135)][_0x23b53e(0x14f)]&&(_0x4f91b4[_0x23b53e(0x15c)](null),this[_0x23b53e(0x135)][_0x23b53e(0x14f)]=null));},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x159)]=function(){const _0x5115d1=_0x1c877c;this[_0x5115d1(0x118)][_0x5115d1(0x19b)](),this['setupText']();if(this[_0x5115d1(0x109)][_0x5115d1(0x1aa)]>0x0){this['resizeWindow']();const _0x58d149=this['baseTextRect']();this[_0x5115d1(0x199)](this['_text'],_0x58d149['x'],_0x58d149['y'],_0x58d149[_0x5115d1(0x12c)]),this[_0x5115d1(0xea)]();}else'PtGoG'===_0x5115d1(0x13c)?this[_0x5115d1(0xf2)]():this['_cache_StateTooltips'][_0x5115d1(0x16f)]=!![];},Window_StateTooltip['prototype'][_0x1c877c(0x120)]=function(_0x4e8847){return _0x4e8847;},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x166)]=function(){return![];},Window_StateTooltip[_0x1c877c(0x187)]['setupText']=function(){const _0x223a2f=_0x1c877c;this['_text']='';if(!this[_0x223a2f(0x192)])return;this['setupStateText'](),this[_0x223a2f(0x1b9)](),this['replaceHexColors'](),this['_text']=this[_0x223a2f(0x109)]['trim']();},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x160)]=function(){const _0x2d3499=_0x1c877c,_0x1d1717=Window_StateTooltip[_0x2d3499(0x1a7)],_0x2691b9=this[_0x2d3499(0x192)][_0x2d3499(0x11f)]();for(const _0x4e1090 of _0x2691b9){if(!_0x4e1090)continue;if(!_0x4e1090['name'][_0x2d3499(0x184)]())continue;if(_0x4e1090[_0x2d3499(0x180)]['match'](/-----/i))continue;if(_0x4e1090[_0x2d3499(0x169)]<=0x0)continue;const _0x382ebf=VisuMZ[_0x2d3499(0x19a)]['RegExp'];if(_0x4e1090[_0x2d3499(0x149)]['match'](_0x382ebf[_0x2d3499(0x134)]))continue;const _0x52122b='\x5cI[%1]'[_0x2d3499(0x189)](_0x4e1090[_0x2d3499(0x169)]),_0x5df6f2=_0x4e1090[_0x2d3499(0x180)]['trim'](),_0x8c239=_0x4e1090[_0x2d3499(0x14c)][_0x2d3499(0x189)](this[_0x2d3499(0x192)]['getStateDisplay'](_0x4e1090['id'])),_0x20120c=this[_0x2d3499(0x15d)](_0x4e1090),_0x224fe2=ColorManager[_0x2d3499(0x1a1)](_0x4e1090),_0x59ebfb=_0x1d1717[_0x2d3499(0x189)](_0x52122b,_0x5df6f2,_0x8c239,_0x20120c,_0x224fe2)[_0x2d3499(0x184)]();if(_0x59ebfb){if(_0x2d3499(0x100)!==_0x2d3499(0x142))this[_0x2d3499(0x109)]+=_0x59ebfb+'\x0a';else{const _0x1d00a5=_0xf416e[_0x2d3499(0x101)],_0x132f56=this[_0x2d3499(0x192)][_0x2d3499(0x191)](_0x5adcf4),_0x3e3a0a=this['_battler'][_0x2d3499(0x19c)](_0x305f98),_0x3af638=_0x3e3a0a?_0x56ae22[_0x2d3499(0x1a5)]():_0x4bda65[_0x2d3499(0x132)]();return _0x1d00a5['format'](_0x132f56,_0x3af638)['trim']();}}}},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x15d)]=function(_0x4953aa){const _0xa21ada=_0x1c877c;if(_0x4953aa[_0xa21ada(0x15a)]===0x0)return'';if(this[_0xa21ada(0x192)][_0xa21ada(0x16b)]()[_0xa21ada(0x16a)](_0x4953aa))return Window_StateTooltip[_0xa21ada(0x10d)];let _0x62188f=_0x4953aa[_0xa21ada(0x15a)]===0x1?Window_StateTooltip['ACTIONS_FMT']:Window_StateTooltip[_0xa21ada(0x101)];const _0x429091=this[_0xa21ada(0x192)][_0xa21ada(0x16c)](_0x4953aa['id'])||0x0,_0x5c2afd=ColorManager[_0xa21ada(0x1a1)](_0x4953aa);return _0x62188f[_0xa21ada(0x189)](_0x429091,_0x5c2afd)['trim']();},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x1b9)]=function(){const _0x77ef4a=_0x1c877c,_0x5b01b1=Window_StateTooltip[_0x77ef4a(0x18c)],_0x275cd4=Window_StateTooltip[_0x77ef4a(0x186)];for(let _0x25932a=0x0;_0x25932a<0x8;_0x25932a++){if(!this[_0x77ef4a(0x192)][_0x77ef4a(0x12e)](_0x25932a))continue;const _0x459957=this[_0x77ef4a(0x192)]['isBuffAffected'](_0x25932a),_0x1bf37f=_0x459957?_0x5b01b1:_0x275cd4,_0x108402=this[_0x77ef4a(0x192)][_0x77ef4a(0x1a0)](this[_0x77ef4a(0x192)]['_buffs'][_0x25932a],_0x25932a),_0x3bc669=_0x77ef4a(0x1a3)[_0x77ef4a(0x189)](_0x108402),_0x16283e=TextManager['param'](_0x25932a),_0x1e3780=Math[_0x77ef4a(0x175)](this[_0x77ef4a(0x192)][_0x77ef4a(0x15b)](_0x25932a)*0x64),_0x293fb8=this[_0x77ef4a(0x193)](_0x25932a),_0x59b557=_0x459957?ColorManager[_0x77ef4a(0x1a5)]():ColorManager[_0x77ef4a(0x132)](),_0x7d4d6b=_0x1bf37f['format'](_0x3bc669,_0x16283e,_0x1e3780,_0x293fb8,_0x59b557)[_0x77ef4a(0x184)]();_0x7d4d6b&&(this['_text']+=_0x7d4d6b+'\x0a');}},Window_StateTooltip['prototype'][_0x1c877c(0x193)]=function(_0xc2539d){const _0x48f07a=_0x1c877c,_0x4af83b=Window_StateTooltip['TURNS_FMT'],_0x3393b6=this['_battler'][_0x48f07a(0x191)](_0xc2539d),_0x21a0a3=this[_0x48f07a(0x192)][_0x48f07a(0x19c)](_0xc2539d),_0x432bc1=_0x21a0a3?ColorManager['buffColor']():ColorManager[_0x48f07a(0x132)]();return _0x4af83b[_0x48f07a(0x189)](_0x3393b6,_0x432bc1)[_0x48f07a(0x184)]();},Window_StateTooltip['prototype'][_0x1c877c(0x17c)]=function(){const _0x43bfbb=_0x1c877c,_0x3022cd=/\\C\[#(.*?)\]/g;this[_0x43bfbb(0x109)]=this[_0x43bfbb(0x109)][_0x43bfbb(0x1b0)](_0x3022cd,(_0x3c9e77,_0x587c33)=>{const _0x1f68f5=_0x43bfbb;if(_0x587c33===_0x1f68f5(0x188)){const _0x2b197f=ColorManager[_0x1f68f5(0x103)](Window_StateTooltip[_0x1f68f5(0x197)]);_0x587c33=_0x2b197f[_0x1f68f5(0x1b0)](/#/g,'');}return _0x1f68f5(0x110)['format'](_0x587c33);});},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x115)]=function(_0x41af73,_0x11b0b6){const _0x53bd56=_0x1c877c;switch(_0x41af73){case _0x53bd56(0x1ae):const _0x10e119=this[_0x53bd56(0x136)](_0x11b0b6);if(!this[_0x53bd56(0x15f)]()&&_0x11b0b6['drawing']){if(_0x53bd56(0x1b3)==='ytQCd')return this[_0x53bd56(0x18d)]&&this[_0x53bd56(0x18d)][_0x53bd56(0xf3)]===_0x38fc4e;else this['changeTextColor'](_0x10e119);}break;default:Window_Base['prototype'][_0x53bd56(0x115)][_0x53bd56(0x10c)](this,_0x41af73,_0x11b0b6);}},Window_StateTooltip[_0x1c877c(0x187)]['resizeWindow']=function(){const _0x3ee80d=_0x1c877c,_0x549f91=this[_0x3ee80d(0x164)](this['_text']);this[_0x3ee80d(0x12c)]=_0x549f91['width']+(this['itemPadding']()+this[_0x3ee80d(0x179)])*0x2,this[_0x3ee80d(0x151)]=_0x549f91[_0x3ee80d(0x151)]+this['padding']*0x2,this[_0x3ee80d(0x185)](),this['resetFontSettings']();},Window_StateTooltip['prototype']['update']=function(){const _0x5d8aa9=_0x1c877c;Window_Base[_0x5d8aa9(0x187)][_0x5d8aa9(0xf5)][_0x5d8aa9(0x10c)](this),this[_0x5d8aa9(0x154)]&&(this[_0x5d8aa9(0x154)]=![],this[_0x5d8aa9(0x159)]()),this[_0x5d8aa9(0x140)](),this[_0x5d8aa9(0x162)](),this[_0x5d8aa9(0x174)]();},Window_StateTooltip[_0x1c877c(0x187)]['requestRefresh']=function(){this['_requestRefresh']=!![];},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x140)]=function(){const _0x5bdb1d=_0x1c877c;if(!this['visible'])return;this['x']=TouchInput['x']+Window_StateTooltip[_0x5bdb1d(0x138)],this['y']=TouchInput['y']+Window_StateTooltip[_0x5bdb1d(0x126)],this[_0x5bdb1d(0x116)]();},Window_StateTooltip[_0x1c877c(0x187)]['clampPosition']=function(){const _0x5b7f6e=_0x1c877c,_0x2a5080=this[_0x5b7f6e(0x12c)]*(Window_StateTooltip[_0x5b7f6e(0x106)]||0.01),_0x2ae82d=this['height']*(Window_StateTooltip[_0x5b7f6e(0x106)]||0.01);this['x']=Math['round'](this['x'][_0x5b7f6e(0x14a)](0x0,Graphics[_0x5b7f6e(0x12c)]-_0x2a5080)),this['y']=Math[_0x5b7f6e(0x114)](this['y']['clamp'](0x0,Graphics[_0x5b7f6e(0x151)]-_0x2ae82d));},Window_StateTooltip[_0x1c877c(0x187)][_0x1c877c(0x162)]=function(){const _0x59c356=_0x1c877c;this['_battler']&&this['_battler'][_0x59c356(0x1ad)]()&&this[_0x59c356(0x123)](null);},Window_StateTooltip['prototype']['updateOpacity']=function(){const _0x46632a=_0x1c877c,_0xa225b7=this[_0x46632a(0xf1)]();this[_0x46632a(0x12b)]=this[_0x46632a(0x129)]=_0xa225b7;},Window_StateTooltip['prototype'][_0x1c877c(0xf1)]=function(){const _0x500a6c=_0x1c877c;if(SceneManager[_0x500a6c(0x141)]()){const _0x42232b=[];_0x42232b[_0x500a6c(0x10a)](SceneManager[_0x500a6c(0x18d)][_0x500a6c(0x158)]),_0x42232b['push'](SceneManager[_0x500a6c(0x18d)]['_itemWindow']),_0x42232b[_0x500a6c(0x10a)](SceneManager[_0x500a6c(0x18d)][_0x500a6c(0x1a9)]);for(const _0x19ceea of _0x42232b){if(_0x19ceea&&_0x19ceea[_0x500a6c(0xfb)]()&&_0x19ceea['active']&&_0x19ceea[_0x500a6c(0x157)]()){if(_0x500a6c(0x170)===_0x500a6c(0x16e)){const _0x1899f0=this['getStateTooltipBattler']();_0x1899f0&&_0x4928ec[_0x500a6c(0x15c)](_0x1899f0);}else return 0x0;}}}return 0xff;};